/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicButtonUI;

public class UsualColoredButtonUI
extends BasicButtonUI {
    private Color backgroundColor;
    private Color foregroundColor;

    public UsualColoredButtonUI(Color backgroundColor, Color foregroundColor) {
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        Graphics2D g2D = (Graphics2D)g;
        JButton myButton = (JButton)component;
        Font buttonFont = new Font(myButton.getFont().getName(), 0, myButton.getFont().getSize());
        myButton.setFont(buttonFont);
        myButton.setBorder(new LineBorder(Color.BLACK, 1));
        if ((double)Color.RGBtoHSB(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), null)[2] < 0.5) {
            myButton.setForeground(Color.WHITE);
        } else {
            myButton.setForeground(this.foregroundColor);
        }
        g2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        ButtonModel buttonModel = myButton.getModel();
        if (buttonModel.isPressed() || buttonModel.isSelected()) {
            Color changedColor = (double)Color.RGBtoHSB(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), null)[2] < 0.5 ? (this.backgroundColor.equals(Color.BLACK) ? Color.DARK_GRAY : this.backgroundColor.brighter()) : this.backgroundColor.darker();
            g2D.setColor(changedColor);
        } else {
            g2D.setColor(this.backgroundColor);
        }
        g2D.fillRoundRect(0, 0, component.getWidth(), component.getHeight(), 3, 3);
        super.paint(g2D, component);
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }
}

